package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.Alert;
import ru.yandex.monitoring.api.v3.CreateAlertRequest;
import ru.yandex.monitoring.api.v3.DeleteAlertRequest;
import ru.yandex.monitoring.api.v3.ExplainAlertEvaluationRequest;
import ru.yandex.monitoring.api.v3.ExplainAlertEvaluationResponse;
import ru.yandex.monitoring.api.v3.ExplainNewAlertEvaluationRequest;
import ru.yandex.monitoring.api.v3.ExplainNewAlertEvaluationResponse;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStateRequest;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStateResponse;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStatsRequest;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStatsResponse;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStateRequest;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStateResponse;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStatsRequest;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStatsResponse;
import ru.yandex.monitoring.api.v3.GetAlertRequest;
import ru.yandex.monitoring.api.v3.GetAlertStatsRequest;
import ru.yandex.monitoring.api.v3.GetAlertStatsResponse;
import ru.yandex.monitoring.api.v3.ListAlertsRequest;
import ru.yandex.monitoring.api.v3.ListAlertsResponse;
import ru.yandex.monitoring.api.v3.ListFullAlertsRequest;
import ru.yandex.monitoring.api.v3.ListFullAlertsResponse;
import ru.yandex.monitoring.api.v3.MuteAlertRequest;
import ru.yandex.monitoring.api.v3.UnmuteAlertRequest;
import ru.yandex.monitoring.api.v3.UpdateAlertRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface AlertService {
    CompletableFuture<Pair<Alert, Integer>> get(GetAlertRequest request, AuthSubject subject);

    CompletableFuture<ListAlertsResponse> list(ListAlertsRequest request, AuthSubject subject);

    CompletableFuture<ListFullAlertsResponse> listFull(ListFullAlertsRequest request, AuthSubject subject);

    CompletableFuture<Alert> create(CreateAlertRequest request, AuthSubject subject);

    CompletableFuture<Alert> update(UpdateAlertRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteAlertRequest request, AuthSubject subject);

    CompletableFuture<GetAlertEvaluationStatsResponse> getEvaluationStats(
            GetAlertEvaluationStatsRequest request,
            AuthSubject subject);

    CompletableFuture<GetAlertNotificationStatsResponse> getNotificationStats(
            GetAlertNotificationStatsRequest request,
            AuthSubject subject);

    CompletableFuture<GetAlertEvaluationStateResponse> getEvaluationState(
            GetAlertEvaluationStateRequest request,
            AuthSubject subject);

    CompletableFuture<GetAlertNotificationStateResponse> getNotificationState(
            GetAlertNotificationStateRequest request,
            AuthSubject subject);

    CompletableFuture<ExplainAlertEvaluationResponse> explainEvaluation(
            ExplainAlertEvaluationRequest request,
            AuthSubject subject);

    CompletableFuture<ExplainNewAlertEvaluationResponse> explainNewEvaluation(
            ExplainNewAlertEvaluationRequest request,
            AuthSubject subject);

    CompletableFuture<GetAlertStatsResponse> getStats(
            GetAlertStatsRequest request,
            AuthSubject subject);

    CompletableFuture<Alert> mute(MuteAlertRequest request, AuthSubject subject, int etag);

    CompletableFuture<Alert> unmute(UnmuteAlertRequest request, AuthSubject subject, int etag);
}
