package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.AlertTemplate;
import ru.yandex.monitoring.api.v3.CreateAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.DeployAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.ListAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.ListAlertTemplateResponse;
import ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsRequest;
import ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsResponse;
import ru.yandex.monitoring.api.v3.PublishAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.ReadAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.UnpublishAlertTemplateRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface AlertTemplateService {

    CompletableFuture<AlertTemplate> create(CreateAlertTemplateRequest createAlertTemplateRequest, AuthSubject subject);

    CompletableFuture<AlertTemplate> read(ReadAlertTemplateRequest request, AuthSubject subject);

    CompletableFuture<AlertTemplate> publish(PublishAlertTemplateRequest request, AuthSubject subject);

    CompletableFuture<Void> unpublish(UnpublishAlertTemplateRequest request, AuthSubject subject);

    CompletableFuture<String> deploy(DeployAlertTemplateRequest request, AuthSubject subject);

    CompletableFuture<ListAlertTemplateVersionsResponse> listTemplateVersions(ListAlertTemplateVersionsRequest listAlertTemplateVersionsRequest, AuthSubject subject);

    CompletableFuture<ListAlertTemplateResponse> listTemplates(ListAlertTemplateRequest listAlertTemplateRequest, AuthSubject subject);
}
