package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.Channel;
import ru.yandex.monitoring.api.v3.CreateChannelRequest;
import ru.yandex.monitoring.api.v3.DeleteChannelRequest;
import ru.yandex.monitoring.api.v3.GetChannelRequest;
import ru.yandex.monitoring.api.v3.ListChannelsRequest;
import ru.yandex.monitoring.api.v3.ListChannelsResponse;
import ru.yandex.monitoring.api.v3.UpdateChannelRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ChannelService {
    CompletableFuture<Pair<Channel, Integer>> get(GetChannelRequest request, AuthSubject subject);

    CompletableFuture<ListChannelsResponse> list(ListChannelsRequest request, AuthSubject subject);

    CompletableFuture<Channel> create(CreateChannelRequest request, AuthSubject subject);

    CompletableFuture<Channel> update(UpdateChannelRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteChannelRequest request, AuthSubject subject);
}
