package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.Cluster;
import ru.yandex.monitoring.api.v3.CreateClusterRequest;
import ru.yandex.monitoring.api.v3.DeleteClusterRequest;
import ru.yandex.monitoring.api.v3.GetClusterRequest;
import ru.yandex.monitoring.api.v3.ListClusterServicesRequest;
import ru.yandex.monitoring.api.v3.ListClusterServicesResponse;
import ru.yandex.monitoring.api.v3.ListClustersRequest;
import ru.yandex.monitoring.api.v3.ListClustersResponse;
import ru.yandex.monitoring.api.v3.UpdateClusterRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ClusterService {
    CompletableFuture<Pair<Cluster, Integer>> get(GetClusterRequest request, AuthSubject subject);

    CompletableFuture<ListClustersResponse> list(ListClustersRequest request, AuthSubject subject);

    CompletableFuture<Cluster> create(CreateClusterRequest request, AuthSubject subject);

    CompletableFuture<Cluster> update(UpdateClusterRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteClusterRequest request, AuthSubject subject);

    CompletableFuture<ListClusterServicesResponse> listServices(ListClusterServicesRequest request, AuthSubject subject);
}
