package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.api.v3.CreateDashboardRequest;
import ru.yandex.monitoring.api.v3.Dashboard;
import ru.yandex.monitoring.api.v3.DeleteDashboardRequest;
import ru.yandex.monitoring.api.v3.GetDashboardRequest;
import ru.yandex.monitoring.api.v3.ListDashboardsRequest;
import ru.yandex.monitoring.api.v3.ListDashboardsResponse;
import ru.yandex.monitoring.api.v3.UpdateDashboardRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface DashboardService {
    CompletableFuture<Dashboard> get(GetDashboardRequest request, AuthSubject subject);

    CompletableFuture<ListDashboardsResponse> list(ListDashboardsRequest request, AuthSubject subject);

    CompletableFuture<Dashboard> create(CreateDashboardRequest request, AuthSubject subject);

    CompletableFuture<Dashboard> update(UpdateDashboardRequest request, AuthSubject subject);

    CompletableFuture<Empty> delete(DeleteDashboardRequest request, AuthSubject subject);
}
