package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.ReadMetricsDataRequest;
import ru.yandex.monitoring.api.v3.ReadMetricsDataResponse;
import ru.yandex.monitoring.api.v3.WriteMetricsDataRequest;
import ru.yandex.monitoring.api.v3.WriteMetricsDataResponse;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface MetricsDataService {
    CompletableFuture<ReadMetricsDataResponse> read(ReadMetricsDataRequest request, AuthSubject subject);

    CompletableFuture<WriteMetricsDataResponse> write(WriteMetricsDataRequest request, AuthSubject subject);
    CompletableFuture<WriteMetricsDataResponse> writeRawData(
            String projectId,
            String cluster,
            String service,
            @Nullable String contentType,
            byte[] body,
            AuthSubject subject);
}
