package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import ru.yandex.monitoring.api.v3.CancelDeleteMetricsOperationRequest;
import ru.yandex.monitoring.api.v3.CreateDeleteMetricsOperationRequest;
import ru.yandex.monitoring.api.v3.DeleteMetricsOperation;
import ru.yandex.monitoring.api.v3.GetDeleteMetricsOperationRequest;
import ru.yandex.monitoring.api.v3.ListDeleteMetricsOperationsRequest;
import ru.yandex.monitoring.api.v3.ListDeleteMetricsOperationsResponse;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Stanislav Kashirin
 */
public interface MetricsDeletionService {
    CompletableFuture<Operation> create(
        CreateDeleteMetricsOperationRequest request,
        AuthSubject subject);

    CompletableFuture<DeleteMetricsOperation> get(
        GetDeleteMetricsOperationRequest request,
        AuthSubject subject);

    CompletableFuture<Operation> cancel(
        CancelDeleteMetricsOperationRequest request,
        AuthSubject subject);

    CompletableFuture<DeleteMetricsOperation> cancelV2(
        CancelDeleteMetricsOperationRequest request,
        AuthSubject subject);

    CompletableFuture<ListDeleteMetricsOperationsResponse> list(
        ListDeleteMetricsOperationsRequest request,
        AuthSubject subject);
}
