package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.ListAllLabelValuesRequest;
import ru.yandex.monitoring.api.v3.ListAllLabelValuesResponse;
import ru.yandex.monitoring.api.v3.ListLabelKeysRequest;
import ru.yandex.monitoring.api.v3.ListLabelKeysResponse;
import ru.yandex.monitoring.api.v3.ListLabelValuesRequest;
import ru.yandex.monitoring.api.v3.ListLabelValuesResponse;
import ru.yandex.monitoring.api.v3.ListMetricNamesRequest;
import ru.yandex.monitoring.api.v3.ListMetricNamesResponse;
import ru.yandex.monitoring.api.v3.ListMetricsRequest;
import ru.yandex.monitoring.api.v3.ListMetricsResponse;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface MetricsMetaService {
    CompletableFuture<ListMetricsResponse> listMetrics(ListMetricsRequest request, AuthSubject subject);

    CompletableFuture<ListMetricNamesResponse> listMetricNames(ListMetricNamesRequest request, AuthSubject subject);

    CompletableFuture<ListLabelKeysResponse> listLabelKeys(ListLabelKeysRequest request, AuthSubject subject);

    CompletableFuture<ListLabelValuesResponse> listLabelValues(ListLabelValuesRequest request, AuthSubject subject);

    CompletableFuture<ListAllLabelValuesResponse> listAllLabelValues(ListAllLabelValuesRequest request, AuthSubject subject);
}
