package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.api.v3.RoleListRequest;
import ru.yandex.monitoring.api.v3.RoleListResponse;
import ru.yandex.monitoring.api.v3.UpdateRoleListRequest;
import ru.yandex.monitoring.api.v3.UpdateRoleListStatusResponse;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface ProjectRoleService {
    CompletableFuture<Empty> update(UpdateRoleListRequest updateRoleListRequest, AuthSubject subject);

    CompletableFuture<RoleListResponse> list(RoleListRequest listRequest, AuthSubject subject);

    CompletableFuture<UpdateRoleListStatusResponse> status(UpdateRoleListRequest request, AuthSubject subject);
}
