package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.CreateProjectRequest;
import ru.yandex.monitoring.api.v3.DeleteProjectRequest;
import ru.yandex.monitoring.api.v3.GetProjectRequest;
import ru.yandex.monitoring.api.v3.ListProjectsRequest;
import ru.yandex.monitoring.api.v3.ListProjectsResponse;
import ru.yandex.monitoring.api.v3.Project;
import ru.yandex.monitoring.api.v3.UpdateProjectRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ProjectService {
    CompletableFuture<Pair<Project, Integer>> get(GetProjectRequest request, AuthSubject subject);

    CompletableFuture<ListProjectsResponse> list(ListProjectsRequest request, AuthSubject subject);

    CompletableFuture<Project> create(CreateProjectRequest request, AuthSubject subject);

    CompletableFuture<Project> update(UpdateProjectRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteProjectRequest request, AuthSubject subject);
}
