package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.CreateQuickLinksRequest;
import ru.yandex.monitoring.api.v3.DeleteQuickLinksRequest;
import ru.yandex.monitoring.api.v3.GetQuickLinksRequest;
import ru.yandex.monitoring.api.v3.QuickLinks;
import ru.yandex.monitoring.api.v3.UpdateQuickLinksRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface QuickLinksService {
    CompletableFuture<Pair<QuickLinks, Integer>> get(GetQuickLinksRequest request, AuthSubject subject);

    CompletableFuture<QuickLinks> create(CreateQuickLinksRequest request, AuthSubject subject);

    CompletableFuture<QuickLinks> update(UpdateQuickLinksRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteQuickLinksRequest request, AuthSubject subject);
}
