package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.api.v3.CreateResourceRequest;
import ru.yandex.monitoring.api.v3.DeleteResourceRequest;
import ru.yandex.monitoring.api.v3.GetResourceRequest;
import ru.yandex.monitoring.api.v3.ListResourcesRequest;
import ru.yandex.monitoring.api.v3.ListResourcesResponse;
import ru.yandex.monitoring.api.v3.ServiceProviderResource;
import ru.yandex.monitoring.api.v3.UpdateResourceRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface ResourceService {
    CompletableFuture<ServiceProviderResource> get(GetResourceRequest request, AuthSubject subject);

    CompletableFuture<ListResourcesResponse> list(ListResourcesRequest request, AuthSubject subject);

    CompletableFuture<ServiceProviderResource> create(CreateResourceRequest request, AuthSubject subject);

    CompletableFuture<ServiceProviderResource> update(UpdateResourceRequest request, AuthSubject subject);

    CompletableFuture<Empty> delete(DeleteResourceRequest request, AuthSubject subject);

    CompletableFuture<Void> upsert(List<CreateResourceRequest> requests, boolean removeOther, String serviceProviderId);
}
