package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.CreateServiceRequest;
import ru.yandex.monitoring.api.v3.DeleteServiceRequest;
import ru.yandex.monitoring.api.v3.GetServiceRequest;
import ru.yandex.monitoring.api.v3.ListServiceClustersRequest;
import ru.yandex.monitoring.api.v3.ListServiceClustersResponse;
import ru.yandex.monitoring.api.v3.ListServicesRequest;
import ru.yandex.monitoring.api.v3.ListServicesResponse;
import ru.yandex.monitoring.api.v3.Service;
import ru.yandex.monitoring.api.v3.UpdateServiceRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ServiceService {
    CompletableFuture<Pair<Service, Integer>> get(GetServiceRequest request, AuthSubject subject);

    CompletableFuture<ListServicesResponse> list(ListServicesRequest request, AuthSubject subject);

    CompletableFuture<Service> create(CreateServiceRequest request, AuthSubject subject);

    CompletableFuture<Service> update(UpdateServiceRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteServiceRequest request, AuthSubject subject);

    CompletableFuture<ListServiceClustersResponse> listClusters(ListServiceClustersRequest request, AuthSubject subject);
}
