package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.CreateShardRequest;
import ru.yandex.monitoring.api.v3.DeleteShardRequest;
import ru.yandex.monitoring.api.v3.GetShardRequest;
import ru.yandex.monitoring.api.v3.ListShardTargetsRequest;
import ru.yandex.monitoring.api.v3.ListShardTargetsResponse;
import ru.yandex.monitoring.api.v3.ListShardsRequest;
import ru.yandex.monitoring.api.v3.ListShardsResponse;
import ru.yandex.monitoring.api.v3.Shard;
import ru.yandex.monitoring.api.v3.UpdateShardRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ShardService {
    CompletableFuture<Pair<Shard, Integer>> get(GetShardRequest request, AuthSubject subject);

    CompletableFuture<ListShardsResponse> list(ListShardsRequest request, AuthSubject subject);

    CompletableFuture<Shard> create(CreateShardRequest request, AuthSubject subject);

    CompletableFuture<Shard> update(UpdateShardRequest request, AuthSubject subject, int etag);

    CompletableFuture<Empty> delete(DeleteShardRequest request, AuthSubject subject);

    CompletableFuture<ListShardTargetsResponse> listTargets(ListShardTargetsRequest request, AuthSubject subject);
}
