package ru.yandex.solomon.gateway.api.v3.intranet;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.ExplainSubAlertEvaluationRequest;
import ru.yandex.monitoring.api.v3.ExplainSubAlertEvaluationResponse;
import ru.yandex.monitoring.api.v3.GetSubAlertEvaluationStateRequest;
import ru.yandex.monitoring.api.v3.GetSubAlertEvaluationStateResponse;
import ru.yandex.monitoring.api.v3.GetSubAlertNotificationStateRequest;
import ru.yandex.monitoring.api.v3.GetSubAlertNotificationStateResponse;
import ru.yandex.monitoring.api.v3.GetSubAlertRequest;
import ru.yandex.monitoring.api.v3.ListSubAlertsRequest;
import ru.yandex.monitoring.api.v3.ListSubAlertsResponse;
import ru.yandex.monitoring.api.v3.SubAlert;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface SubAlertService {
    CompletableFuture<SubAlert> get(GetSubAlertRequest request, AuthSubject subject);

    CompletableFuture<ListSubAlertsResponse> list(ListSubAlertsRequest request, AuthSubject subject);

    CompletableFuture<GetSubAlertEvaluationStateResponse> getEvaluationState(GetSubAlertEvaluationStateRequest request, AuthSubject subject);

    CompletableFuture<GetSubAlertNotificationStateResponse> getNotificationState(GetSubAlertNotificationStateRequest request, AuthSubject subject);

    CompletableFuture<ExplainSubAlertEvaluationResponse> explainEvaluation(ExplainSubAlertEvaluationRequest request, AuthSubject subject);
}
