package ru.yandex.solomon.gateway.api.v3.intranet.dto;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.util.Timestamps;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.CreateProjectRequest;
import ru.yandex.monitoring.api.v3.Project;
import ru.yandex.monitoring.api.v3.UpdateProjectRequest;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProjectDtoConverter {
    public static Pair<Project, Integer> fromModelWithVersion(ru.yandex.solomon.core.db.model.Project project) {
        var dto = fromModel(project);
        var version = project.getVersion();
        return Pair.of(dto, version);
    }

    public static Project fromModel(ru.yandex.solomon.core.db.model.Project project) {
        return Project.newBuilder()
                .setId(project.getId())
                .setCreatedAt(Timestamps.fromMillis(project.getCreatedAtMillis()))
                .setModifiedAt(Timestamps.fromMillis(project.getUpdatedAtMillis()))
                .setCreatedBy(project.getCreatedBy())
                .setModifiedBy(project.getUpdatedBy())
                .setName(project.getName())
                .setDescription(project.getDescription())
                .setAbcService(project.getAbcService())
                .setMetricNameLabel(project.getMetricNameLabel())
                .setMetricNameShardsOnly(project.isOnlyMetricNameShards())
                .setOnlyNewFormatReads(project.isOnlyNewFormatReads())
                .setOnlyNewFormatWrites(project.isOnlyNewFormatWrites())
                .putAllLabels(project.getLabels())
                .build();
    }

    public static ru.yandex.solomon.core.db.model.Project toModel(CreateProjectRequest request, String login, Instant now) {
        return ru.yandex.solomon.core.db.model.Project.newBuilder()
                .setId(request.getId())
                .setCreatedAt(now)
                .setUpdatedAt(now)
                .setCreatedBy(login)
                .setUpdatedBy(login)
                .setName(request.getName())
                .setDescription(request.getDescription())
                .setAbcService(request.getAbcService())
                .setOwner(login)
                .setMetricNameLabel(request.getMetricNameLabel())
                .setOnlyMetricNameShards(request.getMetricNameShardsOnly())
                .setOnlyNewFormatReads(request.getOnlyNewFormatReads())
                .setOnlyNewFormatWrites(request.getOnlyNewFormatWrites())
                .setLabels(request.getLabelsMap())
                .build();
    }

    public static ru.yandex.solomon.core.db.model.Project toModel(UpdateProjectRequest request, String login, Instant now, int etag) {
        return ru.yandex.solomon.core.db.model.Project.newBuilder()
                .setId(request.getProjectId())
                .setUpdatedAt(now)
                .setUpdatedBy(login)
                .setName(request.getName())
                .setDescription(request.getDescription())
                .setAbcService(request.getAbcService())
                .setMetricNameLabel(request.getMetricNameLabel())
                .setOnlyMetricNameShards(request.getMetricNameShardsOnly())
                .setOnlyNewFormatReads(request.getOnlyNewFormatReads())
                .setOnlyNewFormatWrites(request.getOnlyNewFormatWrites())
                .setLabels(request.getLabelsMap())
                .setVersion(etag)
                .build();
    }
}
