package ru.yandex.solomon.gateway.api.v3.intranet.dto;

import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.util.Timestamps;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.CreateServiceRequest;
import ru.yandex.monitoring.api.v3.Service;
import ru.yandex.monitoring.api.v3.UpdateServiceRequest;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public final class ServiceDtoConverter {
    public static Pair<Service, Integer> fromModelWithVersion(ru.yandex.solomon.core.db.model.Service service) {
        var model = fromModel(service);
        var version = service.getVersion();
        return Pair.of(model, version);
    }

    public static Service fromModel(ru.yandex.solomon.core.db.model.Service service) {
        return Service.newBuilder()
                .setProjectId(service.getProjectId())
                .setId(service.getId())
                .setCreatedAt(Timestamps.fromMillis(service.getCreatedAtMillis()))
                .setModifiedAt(Timestamps.fromMillis(service.getUpdatedAtMillis()))
                .setCreatedBy(service.getCreatedBy())
                .setModifiedBy(service.getUpdatedBy())
                .setLabelName(service.getName())
                .setDescription(service.getDescription())
                .setShardSettings(ShardSettingsDtoConverter.fromModel(service.getShardSettings()))
                .setMetricNameLabel(service.getMetricNameLabel())
                .setServiceProviderId(service.getServiceProvider())
                .setAddTsArgs(service.isAddTsArgs())
                .putAllLabels(service.getLabels())
                .build();
    }

    public static ru.yandex.solomon.core.db.model.Service toModel(CreateServiceRequest request, String login, Instant now) {
        var builder = ru.yandex.solomon.core.db.model.Service.newBuilder();
        switch (request.getContainerCase()) {
            case PROJECT_ID -> builder.setProjectId(request.getProjectId());
            default -> throw new UnsupportedOperationException("Not implemented container type " + request.getContainerCase());
        }
        builder.setId(request.getServiceId())
                .setCreatedAt(now)
                .setUpdatedAt(now)
                .setCreatedBy(login)
                .setUpdatedBy(login)
                .setName(request.getLabelName())
                .setDescription(request.getDescription())
                .setMetricNameLabel(request.getMetricNameLabel())
                .setAddTsArgs(request.getAddTsArgs())
                .setLabels(request.getLabelsMap());

        if (request.hasShardSettings()) {
            builder.setShardSettings(ShardSettingsDtoConverter.toModel(request.getShardSettings()));
        }
        return builder.build();
    }

    public static ru.yandex.solomon.core.db.model.Service toModel(UpdateServiceRequest request, String login, Instant now, int etag) {
        var builder = ru.yandex.solomon.core.db.model.Service.newBuilder();
        switch (request.getContainerCase()) {
            case PROJECT_ID -> builder.setProjectId(request.getProjectId());
            default -> throw new UnsupportedOperationException("Not implemented container type " + request.getContainerCase());
        }
        builder.setId(request.getServiceId())
                .setUpdatedAt(now)
                .setUpdatedBy(login)
                .setName(request.getLabelName())
                .setDescription(request.getDescription())
                .setMetricNameLabel(request.getMetricNameLabel())
                .setVersion(etag)
                .setAddTsArgs(request.getAddTsArgs())
                .setLabels(request.getLabelsMap());

        if (request.hasShardSettings()) {
            builder.setShardSettings(ShardSettingsDtoConverter.toModel(request.getShardSettings()));
        }
        return builder.build();
    }
}
