package ru.yandex.solomon.gateway.api.v3.intranet.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.Shard;
import ru.yandex.solomon.core.db.model.ShardState;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ShardStateConverter {

    private ShardStateConverter() {
    }

    public static Shard.Mode fromStateModel(ShardState state) {
        return switch (state) {
            case INACTIVE -> Shard.Mode.INACTIVE;
            case READ_ONLY -> Shard.Mode.READ_ONLY;
            case WRITE_ONLY -> Shard.Mode.WRITE_ONLY;
            case RW, ACTIVE -> Shard.Mode.ACTIVE;
        };
    }

    public static ShardState toStateModel(Shard.Mode mode) {
        return switch (mode) {
            case MODE_UNSPECIFIED, ACTIVE, UNRECOGNIZED -> ShardState.DEFAULT;
            case READ_ONLY -> ShardState.READ_ONLY;
            case WRITE_ONLY -> ShardState.WRITE_ONLY;
            case INACTIVE -> ShardState.INACTIVE;
        };
    }
}
