package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.Alert;
import ru.yandex.monitoring.api.v3.AlertServiceGrpc;
import ru.yandex.monitoring.api.v3.CreateAlertRequest;
import ru.yandex.monitoring.api.v3.DeleteAlertRequest;
import ru.yandex.monitoring.api.v3.ExplainAlertEvaluationRequest;
import ru.yandex.monitoring.api.v3.ExplainAlertEvaluationResponse;
import ru.yandex.monitoring.api.v3.ExplainNewAlertEvaluationRequest;
import ru.yandex.monitoring.api.v3.ExplainNewAlertEvaluationResponse;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStateRequest;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStateResponse;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStatsRequest;
import ru.yandex.monitoring.api.v3.GetAlertEvaluationStatsResponse;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStateRequest;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStateResponse;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStatsRequest;
import ru.yandex.monitoring.api.v3.GetAlertNotificationStatsResponse;
import ru.yandex.monitoring.api.v3.GetAlertRequest;
import ru.yandex.monitoring.api.v3.GetAlertStatsRequest;
import ru.yandex.monitoring.api.v3.GetAlertStatsResponse;
import ru.yandex.monitoring.api.v3.ListAlertsRequest;
import ru.yandex.monitoring.api.v3.ListAlertsResponse;
import ru.yandex.monitoring.api.v3.MuteAlertRequest;
import ru.yandex.monitoring.api.v3.UnmuteAlertRequest;
import ru.yandex.monitoring.api.v3.UpdateAlertRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.AlertService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcAlertService extends AlertServiceGrpc.AlertServiceImplBase implements GrpcService {
    private final AlertService service;

    @Autowired
    public GrpcAlertService(AlertService service) {
        this.service = service;
    }

    @Override
    public void get(GetAlertRequest request, StreamObserver<Alert> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void list(ListAlertsRequest request, StreamObserver<ListAlertsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateAlertRequest request, StreamObserver<Alert> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(UpdateAlertRequest request, StreamObserver<Alert> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteAlertRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }

    @Override
    public void getEvaluationStats(GetAlertEvaluationStatsRequest request,
                                   StreamObserver<GetAlertEvaluationStatsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::getEvaluationStats, request, responseObserver);
    }

    @Override
    public void getNotificationStats(GetAlertNotificationStatsRequest request, StreamObserver<GetAlertNotificationStatsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::getNotificationStats, request, responseObserver);
    }

    @Override
    public void getEvaluationState(GetAlertEvaluationStateRequest request,
                                   StreamObserver<GetAlertEvaluationStateResponse> responseObserver) {
        GrpcMethodHandler.handle(service::getEvaluationState, request, responseObserver);
    }

    @Override
    public void getNotificationState(GetAlertNotificationStateRequest request, StreamObserver<GetAlertNotificationStateResponse> responseObserver) {
        GrpcMethodHandler.handle(service::getNotificationState, request, responseObserver);
    }

    @Override
    public void explainEvaluation(ExplainAlertEvaluationRequest request, StreamObserver<ExplainAlertEvaluationResponse> responseObserver) {
        GrpcMethodHandler.handle(service::explainEvaluation, request, responseObserver);
    }

    @Override
    public void explainNewEvaluation(ExplainNewAlertEvaluationRequest request, StreamObserver<ExplainNewAlertEvaluationResponse> responseObserver) {
        GrpcMethodHandler.handle(service::explainNewEvaluation, request, responseObserver);
    }

    @Override
    public void getStats(GetAlertStatsRequest request, StreamObserver<GetAlertStatsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::getStats, request, responseObserver);
    }

    @Override
    public void mute(MuteAlertRequest request, StreamObserver<Alert> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::mute, request, responseObserver);
    }

    @Override
    public void unmute(UnmuteAlertRequest request, StreamObserver<Alert> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::unmute, request, responseObserver);
    }
}
