package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.AlertTemplate;
import ru.yandex.monitoring.api.v3.AlertTemplateServiceGrpc;
import ru.yandex.monitoring.api.v3.CreateAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.DeployAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.ListAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.ListAlertTemplateResponse;
import ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsRequest;
import ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsResponse;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.monitoring.api.v3.PublishAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.ReadAlertTemplateRequest;
import ru.yandex.monitoring.api.v3.UnpublishAlertTemplateRequest;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.gateway.api.v3.intranet.AlertTemplateService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.operation.OperationDtoConverter;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcAlertTemplateService extends AlertTemplateServiceGrpc.AlertTemplateServiceImplBase implements GrpcService {

    private final OperationDtoConverter operationConverter;
    private final AlertTemplateService service;

    public GrpcAlertTemplateService(AlertTemplateService alertTemplateService) {
        this.service = alertTemplateService;
        operationConverter = new OperationDtoConverter();
    }

    @Override
    public void create(CreateAlertTemplateRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle((CreateAlertTemplateRequest request1, AuthSubject subject) ->
                        service.create(request1, subject)
                                .handle(operationConverter::wrap),
                request, responseObserver);
    }

    @Override
    public void read(ReadAlertTemplateRequest request, StreamObserver<AlertTemplate> responseObserver) {
        GrpcMethodHandler.handle(service::read,  request, responseObserver);
    }

    @Override
    public void publish(PublishAlertTemplateRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle((PublishAlertTemplateRequest request1, AuthSubject subject) ->
                        service.publish(request1, subject)
                                .handle(operationConverter::wrap),
                request, responseObserver);
    }

    @Override
    public void unpublish(UnpublishAlertTemplateRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle((UnpublishAlertTemplateRequest request1, AuthSubject subject) ->
                        service.unpublish(request1, subject)
                                .handle(operationConverter::wrap),
                request, responseObserver);
    }

    @Override
    public void deploy(DeployAlertTemplateRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle((DeployAlertTemplateRequest request1, AuthSubject subject) ->
                        service.deploy(request1, subject)
                                .handle((s, throwable) -> operationConverter.wrap(s, throwable).toBuilder()
                                        .setDone(false)
                                        .setDescription("Deploy alert template " + request1.getTemplateId() + ", version " + request1.getTemplateVersionTag())
                                        .build()),
                request, responseObserver);
    }

    @Override
    public void listVersions(ListAlertTemplateVersionsRequest request, StreamObserver<ListAlertTemplateVersionsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listTemplateVersions,  request, responseObserver);
    }

    @Override
    public void list(ListAlertTemplateRequest request, StreamObserver<ListAlertTemplateResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listTemplates,  request, responseObserver);
    }
}
