package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.AlertingStubRequest;
import ru.yandex.monitoring.api.v3.AlertingStubRequestServiceGrpc;
import ru.yandex.monitoring.api.v3.CompleteStubRequest;
import ru.yandex.monitoring.api.v3.CreateStubRequest;
import ru.yandex.monitoring.api.v3.GetStubRequest;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.solomon.gateway.api.v3.intranet.AlertingStubRequestService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.operation.OperationDtoConverter;

/**
 * @author Nuradil Zhambyl
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcAlertingStubRequestService extends AlertingStubRequestServiceGrpc.AlertingStubRequestServiceImplBase implements GrpcService {
    private final AlertingStubRequestService service;
    private final OperationDtoConverter operationConverter;

    @Autowired
    public GrpcAlertingStubRequestService(AlertingStubRequestService service) {
        this.service = service;
        operationConverter = new OperationDtoConverter();
    }

    @Override
    public void get(GetStubRequest request, StreamObserver<AlertingStubRequest> responseObserver) {
        GrpcMethodHandler.handle(service::get, request, responseObserver);
    }

    @Override
    public void create(CreateStubRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void complete(CompleteStubRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::complete, request, responseObserver, operationConverter::wrap);
    }
}
