package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.Channel;
import ru.yandex.monitoring.api.v3.ChannelServiceGrpc;
import ru.yandex.monitoring.api.v3.CreateChannelRequest;
import ru.yandex.monitoring.api.v3.DeleteChannelRequest;
import ru.yandex.monitoring.api.v3.GetChannelRequest;
import ru.yandex.monitoring.api.v3.ListChannelsRequest;
import ru.yandex.monitoring.api.v3.ListChannelsResponse;
import ru.yandex.monitoring.api.v3.UpdateChannelRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.ChannelService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcChannelService extends ChannelServiceGrpc.ChannelServiceImplBase implements GrpcService {
    private final ChannelService channelService;

    @Autowired
    public GrpcChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    public void get(GetChannelRequest request, StreamObserver<Channel> responseObserver) {
        GrpcMethodHandler.handleGet(channelService::get, request, responseObserver);
    }

    @Override
    public void list(ListChannelsRequest request, StreamObserver<ListChannelsResponse> responseObserver) {
        GrpcMethodHandler.handle(channelService::list, request, responseObserver);
    }

    @Override
    public void create(CreateChannelRequest request, StreamObserver<Channel> responseObserver) {
        GrpcMethodHandler.handle(channelService::create, request, responseObserver);
    }

    @Override
    public void update(UpdateChannelRequest request, StreamObserver<Channel> responseObserver) {
        GrpcMethodHandler.handleUpdate(channelService::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteChannelRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(channelService::delete, request, responseObserver);
    }
}
