package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.Cluster;
import ru.yandex.monitoring.api.v3.ClusterServiceGrpc;
import ru.yandex.monitoring.api.v3.CreateClusterRequest;
import ru.yandex.monitoring.api.v3.DeleteClusterRequest;
import ru.yandex.monitoring.api.v3.GetClusterRequest;
import ru.yandex.monitoring.api.v3.ListClusterServicesRequest;
import ru.yandex.monitoring.api.v3.ListClusterServicesResponse;
import ru.yandex.monitoring.api.v3.ListClustersRequest;
import ru.yandex.monitoring.api.v3.ListClustersResponse;
import ru.yandex.monitoring.api.v3.UpdateClusterRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.ClusterService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcClusterService extends ClusterServiceGrpc.ClusterServiceImplBase implements GrpcService {
    private final ClusterService service;

    @Autowired
    public GrpcClusterService(ClusterService service) {
        this.service = service;
    }

    @Override
    public void get(GetClusterRequest request, StreamObserver<Cluster> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void list(ListClustersRequest request, StreamObserver<ListClustersResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateClusterRequest request, StreamObserver<Cluster> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(UpdateClusterRequest request, StreamObserver<Cluster> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteClusterRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }

    @Override
    public void listServices(ListClusterServicesRequest request, StreamObserver<ListClusterServicesResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listServices, request, responseObserver);
    }
}
