package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CreateDashboardRequest;
import ru.yandex.monitoring.api.v3.Dashboard;
import ru.yandex.monitoring.api.v3.DashboardServiceGrpc;
import ru.yandex.monitoring.api.v3.DeleteDashboardRequest;
import ru.yandex.monitoring.api.v3.GetDashboardRequest;
import ru.yandex.monitoring.api.v3.ListDashboardOperationsRequest;
import ru.yandex.monitoring.api.v3.ListDashboardOperationsResponse;
import ru.yandex.monitoring.api.v3.ListDashboardsRequest;
import ru.yandex.monitoring.api.v3.ListDashboardsResponse;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.monitoring.api.v3.UpdateDashboardRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.DashboardService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.operation.OperationDtoConverter;

/**
 * Dashboard gRPC service implementation
 *
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcDashboardService extends DashboardServiceGrpc.DashboardServiceImplBase implements GrpcService {
    private final DashboardService service;
    private final OperationDtoConverter operationConverter;

    @Autowired
    public GrpcDashboardService(DashboardService service) {
        this.service = service;
        operationConverter = new OperationDtoConverter();
    }

    @Override
    public void get(GetDashboardRequest request, StreamObserver<Dashboard> responseObserver) {
        GrpcMethodHandler.handle(service::get, request, responseObserver);
    }

    @Override
    public void list(ListDashboardsRequest request, StreamObserver<ListDashboardsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateDashboardRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void update(UpdateDashboardRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::update, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void delete(DeleteDashboardRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void listOperations(ListDashboardOperationsRequest request, StreamObserver<ListDashboardOperationsResponse> responseObserver) {
        GrpcMethodHandler.SimpleHandlerFunc<ListDashboardOperationsRequest, ListDashboardOperationsResponse> returnEmpty =
                (request1, subject) -> ListDashboardOperationsResponse.getDefaultInstance();
        GrpcMethodHandler.handle(returnEmpty, request, responseObserver);
    }
}
