package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.ExpressionServiceGrpc;
import ru.yandex.monitoring.api.v3.ListFunctionsRequest;
import ru.yandex.monitoring.api.v3.ListFunctionsResponse;
import ru.yandex.monitoring.api.v3.ParseExpressionRequest;
import ru.yandex.monitoring.api.v3.ParseExpressionResponse;
import ru.yandex.solomon.gateway.api.v3.intranet.ExpressionService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcExpressionService extends ExpressionServiceGrpc.ExpressionServiceImplBase implements GrpcService {
    private final ExpressionService service;

    @Autowired
    public GrpcExpressionService(ExpressionService service) {
        this.service = service;
    }

    @Override
    public void listFunctions(ListFunctionsRequest request, StreamObserver<ListFunctionsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listFunctions, request, responseObserver);
    }

    @Override
    public void parseExpression(ParseExpressionRequest request, StreamObserver<ParseExpressionResponse> responseObserver) {
        GrpcMethodHandler.handle(service::parse, request, responseObserver);
    }
}
