package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.MetricsDataServiceGrpc;
import ru.yandex.monitoring.api.v3.ReadMetricsDataRequest;
import ru.yandex.monitoring.api.v3.ReadMetricsDataResponse;
import ru.yandex.monitoring.api.v3.WriteMetricsDataRequest;
import ru.yandex.monitoring.api.v3.WriteMetricsDataResponse;
import ru.yandex.solomon.gateway.api.v3.intranet.MetricsDataService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcMetricsDataService extends MetricsDataServiceGrpc.MetricsDataServiceImplBase implements GrpcService {
    private final MetricsDataService service;

    @Autowired
    public GrpcMetricsDataService(MetricsDataService service) {
        this.service = service;
    }

    @Override
    public void read(ReadMetricsDataRequest request, StreamObserver<ReadMetricsDataResponse> responseObserver) {
        GrpcMethodHandler.handle(service::read, request, responseObserver);
    }

    @Override
    public void write(WriteMetricsDataRequest request, StreamObserver<WriteMetricsDataResponse> responseObserver) {
        GrpcMethodHandler.handle(service::write, request, responseObserver);
    }
}
