package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CancelDeleteMetricsOperationRequest;
import ru.yandex.monitoring.api.v3.CreateDeleteMetricsOperationRequest;
import ru.yandex.monitoring.api.v3.DeleteMetricsOperation;
import ru.yandex.monitoring.api.v3.GetDeleteMetricsOperationRequest;
import ru.yandex.monitoring.api.v3.ListDeleteMetricsOperationsRequest;
import ru.yandex.monitoring.api.v3.ListDeleteMetricsOperationsResponse;
import ru.yandex.monitoring.api.v3.MetricsDeletionServiceGrpc;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.solomon.gateway.api.v3.intranet.MetricsDeletionService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Stanislav Kashirin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcMetricsDeletionService extends MetricsDeletionServiceGrpc.MetricsDeletionServiceImplBase implements GrpcService {

    private final MetricsDeletionService service;

    @Autowired
    public GrpcMetricsDeletionService(MetricsDeletionService service) {
        this.service = service;
    }

    @Override
    public void create(
        CreateDeleteMetricsOperationRequest request,
        StreamObserver<Operation> responseObserver)
    {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void get(
        GetDeleteMetricsOperationRequest request,
        StreamObserver<DeleteMetricsOperation> responseObserver)
    {
        GrpcMethodHandler.handle(service::get, request, responseObserver);
    }

    @Override
    public void cancel(
        CancelDeleteMetricsOperationRequest request,
        StreamObserver<Operation> responseObserver)
    {
        GrpcMethodHandler.handle(service::cancel, request, responseObserver);
    }

    @Override
    public void list(
        ListDeleteMetricsOperationsRequest request,
        StreamObserver<ListDeleteMetricsOperationsResponse> responseObserver)
    {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }
}
