package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.ListAllLabelValuesRequest;
import ru.yandex.monitoring.api.v3.ListAllLabelValuesResponse;
import ru.yandex.monitoring.api.v3.ListLabelKeysRequest;
import ru.yandex.monitoring.api.v3.ListLabelKeysResponse;
import ru.yandex.monitoring.api.v3.ListLabelValuesRequest;
import ru.yandex.monitoring.api.v3.ListLabelValuesResponse;
import ru.yandex.monitoring.api.v3.ListMetricNamesRequest;
import ru.yandex.monitoring.api.v3.ListMetricNamesResponse;
import ru.yandex.monitoring.api.v3.ListMetricsRequest;
import ru.yandex.monitoring.api.v3.ListMetricsResponse;
import ru.yandex.monitoring.api.v3.MetricsMetaServiceGrpc;
import ru.yandex.solomon.gateway.api.v3.intranet.MetricsMetaService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcMetricsMetaService extends MetricsMetaServiceGrpc.MetricsMetaServiceImplBase implements GrpcService {
    private final MetricsMetaService service;

    @Autowired
    public GrpcMetricsMetaService(MetricsMetaService service) {
        this.service = service;
    }

    @Override
    public void listMetrics(ListMetricsRequest request, StreamObserver<ListMetricsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listMetrics, request, responseObserver);
    }

    @Override
    public void listMetricNames(ListMetricNamesRequest request, StreamObserver<ListMetricNamesResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listMetricNames, request, responseObserver);
    }

    @Override
    public void listLabelKeys(ListLabelKeysRequest request, StreamObserver<ListLabelKeysResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listLabelKeys, request, responseObserver);
    }

    @Override
    public void listLabelValues(ListLabelValuesRequest request, StreamObserver<ListLabelValuesResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listLabelValues, request, responseObserver);
    }

    @Override
    public void listAllLabelValues(ListAllLabelValuesRequest request, StreamObserver<ListAllLabelValuesResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listAllLabelValues, request, responseObserver);
    }
}
