package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.GetOperationRequest;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.monitoring.api.v3.OperationServiceGrpc;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.operation.OperationDtoConverter;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcOperationService extends OperationServiceGrpc.OperationServiceImplBase implements GrpcService {

    private final OperationDtoConverter operationConverter;

    public GrpcOperationService() {
        this.operationConverter = new OperationDtoConverter();
    }

    @Override
    public void get(GetOperationRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.SimpleHandlerFunc<GetOperationRequest, Operation> returnEmpty =
                (request1, subject) -> operationConverter.wrap(request.getOperationId(), null);
        GrpcMethodHandler.handle(returnEmpty, request, responseObserver);
    }
}
