package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.ProjectRoleServiceGrpc;
import ru.yandex.monitoring.api.v3.RoleListRequest;
import ru.yandex.monitoring.api.v3.RoleListResponse;
import ru.yandex.monitoring.api.v3.UpdateRoleListRequest;
import ru.yandex.monitoring.api.v3.UpdateRoleListStatusResponse;
import ru.yandex.solomon.gateway.api.v3.intranet.ProjectRoleService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcProjectRoleService extends ProjectRoleServiceGrpc.ProjectRoleServiceImplBase implements GrpcService {
    private final ProjectRoleService service;

    @Autowired
    public GrpcProjectRoleService(Optional<ProjectRoleService> projectRoleService) {
        this.service = projectRoleService.orElse(null);
    }

    @Override
    public void updateRoles(UpdateRoleListRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::update, request, responseObserver);
    }

    @Override
    public void list(RoleListRequest request, StreamObserver<RoleListResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void status(UpdateRoleListRequest request, StreamObserver<UpdateRoleListStatusResponse> responseObserver) {
        GrpcMethodHandler.handle(service::status, request, responseObserver);
    }
}
