package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CreateProjectRequest;
import ru.yandex.monitoring.api.v3.DeleteProjectRequest;
import ru.yandex.monitoring.api.v3.GetProjectRequest;
import ru.yandex.monitoring.api.v3.ListProjectsRequest;
import ru.yandex.monitoring.api.v3.ListProjectsResponse;
import ru.yandex.monitoring.api.v3.Project;
import ru.yandex.monitoring.api.v3.ProjectServiceGrpc;
import ru.yandex.monitoring.api.v3.UpdateProjectRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.ProjectService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcProjectService extends ProjectServiceGrpc.ProjectServiceImplBase implements GrpcService {
    private final ProjectService service;

    @Autowired
    public GrpcProjectService(ProjectService service) {
        this.service = service;
    }

    @Override
    public void get(GetProjectRequest request, StreamObserver<Project> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void list(ListProjectsRequest request, StreamObserver<ListProjectsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateProjectRequest request, StreamObserver<Project> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(UpdateProjectRequest request, StreamObserver<Project> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteProjectRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }
}
