package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CreateQuickLinksRequest;
import ru.yandex.monitoring.api.v3.DeleteQuickLinksRequest;
import ru.yandex.monitoring.api.v3.GetQuickLinksRequest;
import ru.yandex.monitoring.api.v3.QuickLinks;
import ru.yandex.monitoring.api.v3.QuickLinksServiceGrpc;
import ru.yandex.monitoring.api.v3.UpdateQuickLinksRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.QuickLinksService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcQuickLinksService extends QuickLinksServiceGrpc.QuickLinksServiceImplBase implements GrpcService {
    private final QuickLinksService service;

    @Autowired
    public GrpcQuickLinksService(QuickLinksService service) {
        this.service = service;
    }

    @Override
    public void get(GetQuickLinksRequest request, StreamObserver<QuickLinks> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void create(CreateQuickLinksRequest request, StreamObserver<QuickLinks> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(UpdateQuickLinksRequest request, StreamObserver<QuickLinks> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteQuickLinksRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }
}
