package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CreateResourceRequest;
import ru.yandex.monitoring.api.v3.DeleteResourceRequest;
import ru.yandex.monitoring.api.v3.GetResourceRequest;
import ru.yandex.monitoring.api.v3.ListResourceOperationsRequest;
import ru.yandex.monitoring.api.v3.ListResourceOperationsResponse;
import ru.yandex.monitoring.api.v3.ListResourcesRequest;
import ru.yandex.monitoring.api.v3.ListResourcesResponse;
import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.monitoring.api.v3.ServiceProviderResource;
import ru.yandex.monitoring.api.v3.ServiceProviderResourceServiceGrpc;
import ru.yandex.monitoring.api.v3.UpdateResourceRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.ResourceService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;
import ru.yandex.solomon.operation.OperationDtoConverter;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcResourceService extends ServiceProviderResourceServiceGrpc.ServiceProviderResourceServiceImplBase implements GrpcService {
    private final ResourceService service;
    private final OperationDtoConverter operationConverter;

    @Autowired
    public GrpcResourceService(ResourceService service) {
        this.service = service;
        operationConverter = new OperationDtoConverter();
    }

    @Override
    public void get(GetResourceRequest request, StreamObserver<ServiceProviderResource> responseObserver) {
        GrpcMethodHandler.handle(service::get, request, responseObserver);
    }

    @Override
    public void list(ListResourcesRequest request, StreamObserver<ListResourcesResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateResourceRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void update(UpdateResourceRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::update, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void delete(DeleteResourceRequest request, StreamObserver<Operation> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver, operationConverter::wrap);
    }

    @Override
    public void listOperations(ListResourceOperationsRequest request, StreamObserver<ListResourceOperationsResponse> responseObserver) {
        GrpcMethodHandler.SimpleHandlerFunc<ListResourceOperationsRequest, ListResourceOperationsResponse> returnEmpty =
                (request1, subject) -> ListResourceOperationsResponse.getDefaultInstance();
        GrpcMethodHandler.handle(returnEmpty, request, responseObserver);
    }
}
