package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CreateServiceRequest;
import ru.yandex.monitoring.api.v3.DeleteServiceRequest;
import ru.yandex.monitoring.api.v3.GetServiceRequest;
import ru.yandex.monitoring.api.v3.ListServiceClustersRequest;
import ru.yandex.monitoring.api.v3.ListServiceClustersResponse;
import ru.yandex.monitoring.api.v3.ListServicesRequest;
import ru.yandex.monitoring.api.v3.ListServicesResponse;
import ru.yandex.monitoring.api.v3.Service;
import ru.yandex.monitoring.api.v3.ServiceServiceGrpc;
import ru.yandex.monitoring.api.v3.UpdateServiceRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.ServiceService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcServiceService extends ServiceServiceGrpc.ServiceServiceImplBase implements GrpcService {
    private final ServiceService service;

    @Autowired
    public GrpcServiceService(ServiceService service) {
        this.service = service;
    }

    @Override
    public void get(GetServiceRequest request, StreamObserver<Service> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void list(ListServicesRequest request, StreamObserver<ListServicesResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateServiceRequest request, StreamObserver<Service> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(UpdateServiceRequest request, StreamObserver<Service> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteServiceRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }

    @Override
    public void listClusters(ListServiceClustersRequest request, StreamObserver<ListServiceClustersResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listClusters, request, responseObserver);
    }
}
