package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.CreateShardRequest;
import ru.yandex.monitoring.api.v3.DeleteShardRequest;
import ru.yandex.monitoring.api.v3.GetShardRequest;
import ru.yandex.monitoring.api.v3.ListShardTargetsRequest;
import ru.yandex.monitoring.api.v3.ListShardTargetsResponse;
import ru.yandex.monitoring.api.v3.ListShardsRequest;
import ru.yandex.monitoring.api.v3.ListShardsResponse;
import ru.yandex.monitoring.api.v3.Shard;
import ru.yandex.monitoring.api.v3.ShardServiceGrpc;
import ru.yandex.monitoring.api.v3.UpdateShardRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.ShardService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcShardService extends ShardServiceGrpc.ShardServiceImplBase implements GrpcService {
    private final ShardService service;

    @Autowired
    public GrpcShardService(ShardService service) {
        this.service = service;
    }

    @Override
    public void get(GetShardRequest request, StreamObserver<Shard> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void list(ListShardsRequest request, StreamObserver<ListShardsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(CreateShardRequest request, StreamObserver<Shard> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(UpdateShardRequest request, StreamObserver<Shard> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(DeleteShardRequest request, StreamObserver<Empty> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }

    @Override
    public void listTargets(ListShardTargetsRequest request, StreamObserver<ListShardTargetsResponse> responseObserver) {
        GrpcMethodHandler.handle(service::listTargets, request, responseObserver);
    }
}
