package ru.yandex.solomon.gateway.api.v3.intranet.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.ExplainSubAlertEvaluationRequest;
import ru.yandex.monitoring.api.v3.ExplainSubAlertEvaluationResponse;
import ru.yandex.monitoring.api.v3.GetSubAlertEvaluationStateRequest;
import ru.yandex.monitoring.api.v3.GetSubAlertEvaluationStateResponse;
import ru.yandex.monitoring.api.v3.GetSubAlertNotificationStateRequest;
import ru.yandex.monitoring.api.v3.GetSubAlertNotificationStateResponse;
import ru.yandex.monitoring.api.v3.GetSubAlertRequest;
import ru.yandex.monitoring.api.v3.ListSubAlertsRequest;
import ru.yandex.monitoring.api.v3.ListSubAlertsResponse;
import ru.yandex.monitoring.api.v3.SubAlert;
import ru.yandex.monitoring.api.v3.SubAlertServiceGrpc;
import ru.yandex.solomon.gateway.api.v3.intranet.SubAlertService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcSubAlertService extends SubAlertServiceGrpc.SubAlertServiceImplBase implements GrpcService {
    private final SubAlertService subAlertService;

    @Autowired
    public GrpcSubAlertService(SubAlertService subAlertService) {
        this.subAlertService = subAlertService;
    }

    @Override
    public void get(GetSubAlertRequest request, StreamObserver<SubAlert> responseObserver) {
        GrpcMethodHandler.handle(subAlertService::get, request, responseObserver);
    }

    @Override
    public void list(ListSubAlertsRequest request, StreamObserver<ListSubAlertsResponse> responseObserver) {
        GrpcMethodHandler.handle(subAlertService::list, request, responseObserver);
    }

    @Override
    public void getEvaluationState(GetSubAlertEvaluationStateRequest request, StreamObserver<GetSubAlertEvaluationStateResponse> responseObserver) {
        GrpcMethodHandler.handle(subAlertService::getEvaluationState, request, responseObserver);
    }

    @Override
    public void getNotificationState(GetSubAlertNotificationStateRequest request, StreamObserver<GetSubAlertNotificationStateResponse> responseObserver) {
        GrpcMethodHandler.handle(subAlertService::getNotificationState, request, responseObserver);
    }

    @Override
    public void explainEvaluation(ExplainSubAlertEvaluationRequest request, StreamObserver<ExplainSubAlertEvaluationResponse> responseObserver) {
        GrpcMethodHandler.handle(subAlertService::explainEvaluation, request, responseObserver);
    }
}
