package ru.yandex.solomon.gateway.api.v3.intranet.priv;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.monitoring.api.v3.priv.GetProjectAclRequest;
import ru.yandex.monitoring.api.v3.priv.ProjectAcl;
import ru.yandex.monitoring.api.v3.priv.UpdateProjectAclRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ProjectAclService {
    CompletableFuture<Pair<ProjectAcl, Integer>> get(GetProjectAclRequest request, AuthSubject subject);

    CompletableFuture<ProjectAcl> update(UpdateProjectAclRequest request, AuthSubject subject, int etag);
}
