package ru.yandex.solomon.gateway.api.v3.intranet.priv.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.monitoring.api.v3.priv.GetProjectAclRequest;
import ru.yandex.monitoring.api.v3.priv.ProjectAcl;
import ru.yandex.monitoring.api.v3.priv.ProjectAclServiceGrpc;
import ru.yandex.monitoring.api.v3.priv.UpdateProjectAclRequest;
import ru.yandex.solomon.gateway.api.v3.intranet.priv.ProjectAclService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcProjectAclService extends ProjectAclServiceGrpc.ProjectAclServiceImplBase implements GrpcService {
    private final ProjectAclService service;

    @Autowired
    public GrpcProjectAclService(ProjectAclService service) {
        this.service = service;
    }

    @Override
    public void get(GetProjectAclRequest request, StreamObserver<ProjectAcl> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void update(UpdateProjectAclRequest request, StreamObserver<ProjectAcl> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }
}
