package ru.yandex.solomon.gateway.api.v3.intranet.priv.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.priv.UpdateProjectAclRequest;
import ru.yandex.solomon.gateway.api.v2.dto.ValidationUtils;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProjectAclValidator {
    public void validate(UpdateProjectAclRequest request) {
        ValidationUtils.validateLogin("owner login", request.getOwner());

        request.getEntriesList().forEach(aclEntry -> {
            ValidationUtils.validateLogin("acl entry login", aclEntry.getLogin());
        });
    }
}
