package ru.yandex.solomon.gateway.api.v3.intranet.rest;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.monitoring.api.v3.DataType;
import ru.yandex.monitoring.api.v3.FunctionCategory;
import ru.yandex.monitoring.api.v3.ListFunctionsRequest;
import ru.yandex.monitoring.api.v3.ParseExpressionRequest;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.http.RequireAuth;
import ru.yandex.solomon.gateway.api.v3.intranet.ExpressionService;
import ru.yandex.solomon.gateway.api.v3.utils.ProtoJsonUtils;

/**
 * @author Oleg Baryshnikov
 */
@RestController
@RequestMapping(produces = MediaType.APPLICATION_JSON_VALUE)
@ParametersAreNonnullByDefault
public class ExpressionV3Controller {
    private final ExpressionService service;

    public ExpressionV3Controller(ExpressionService service) {
        this.service = service;
    }

    @RequestMapping(path = "/api/v3/expression/functions", method = RequestMethod.GET)
    public String listFunctions(
            @RequireAuth AuthSubject subject,
            @RequestParam(value = "filterByInputType", defaultValue = "DATA_TYPE_UNSPECIFIED") DataType filterByInputType,
            @RequestParam(value = "filterByOutputType", defaultValue = "DATA_TYPE_UNSPECIFIED") DataType filterByOutputType,
            @RequestParam(value = "filterByCategory", defaultValue = "FUNCTION_CATEGORY_UNSPECIFIED") FunctionCategory filterByCategory,
            @RequestParam(value = "version", defaultValue = "0") int version,
            @RequestParam(value = "_pretty", required = false) boolean pretty)
    {
        ListFunctionsRequest request = ListFunctionsRequest.newBuilder()
                .setFilterByCategory(filterByCategory)
                .setFilterByInputType(filterByInputType)
                .setFilterByOutputType(filterByOutputType)
                .setVersion(version)
                .build();

        var response = service.listFunctions(request);

        return ProtoJsonUtils.toJson(response, pretty);
    }

    @RequestMapping(path = "/parse", method = RequestMethod.POST)
    public String parseExpression(
            @RequireAuth AuthSubject subject,
            @RequestBody byte[] body,
            @RequestParam(value = "_pretty", required = false) boolean pretty)
    {
        ParseExpressionRequest.Builder builder = ParseExpressionRequest.newBuilder();
        ProtoJsonUtils.fromJson(body, builder);
        var response = service.parse(builder.build());
        return ProtoJsonUtils.toJson(response, pretty);
    }
}
