package ru.yandex.solomon.gateway.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.CreateProjectRequest;
import ru.yandex.monitoring.api.v3.DeleteProjectRequest;
import ru.yandex.monitoring.api.v3.GetProjectRequest;
import ru.yandex.monitoring.api.v3.ListProjectsRequest;
import ru.yandex.monitoring.api.v3.UpdateProjectRequest;
import ru.yandex.solomon.core.exceptions.BadRequestException;
import ru.yandex.solomon.core.validators.IdValidator;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProjectValidator {

    public static void validate(GetProjectRequest request) {
        if (request.getProjectId().isBlank()) {
            throw new BadRequestException("project ID cannot be blank");
        }
    }

    public static void validate(ListProjectsRequest request) {
    }

    public static void validate(CreateProjectRequest request) {
        IdValidator.ensureProjectIdValid(request.getId());
        if (request.getName().isBlank()) {
            throw new BadRequestException("name cannot be blank");
        }
        if (request.getAbcService().isBlank()) {
            throw new BadRequestException("ABC service cannot be blank");
        }
    }

    public static void validate(UpdateProjectRequest request) {
        IdValidator.ensureProjectIdValid(request.getProjectId());
        if (request.getName().isBlank()) {
            throw new BadRequestException("name cannot be blank");
        }
        if (request.getAbcService().isBlank()) {
            throw new BadRequestException("ABC service cannot be blank");
        }
    }

    public static void validate(DeleteProjectRequest request) {
        if (request.getProjectId().isBlank()) {
            throw new BadRequestException("project ID cannot be blank");
        }
    }
}
