package ru.yandex.solomon.gateway.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.monitoring.api.v3.CreateQuickLinksRequest;
import ru.yandex.monitoring.api.v3.QuickLinksData;
import ru.yandex.monitoring.api.v3.UpdateQuickLinksRequest;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class QuickLinksValidator {
    public static void validate(CreateQuickLinksRequest request) {
        validate(request.getData());
    }

    public static void validate(UpdateQuickLinksRequest request) {
        validate(request.getData());
    }

    public static void validate(QuickLinksData data) {
        for (var item : data.getItemsList()) {
            validate(item);
        }
    }

    private static void validate(QuickLinksData.Item item) {
        switch (item.getTypeCase()) {
            case LINK -> validate(item.getLink());
            case FOLDER -> validate(item.getFolder());
            case TYPE_NOT_SET -> throw new BadRequestException("item type not set");
            default -> throw new IllegalStateException("unknown item type: " + item.getTypeCase());
        }
    }

    private static void validate(QuickLinksData.LinkItem item) {
        if (StringUtils.isBlank(item.getTitle())) {
            throw new BadRequestException("item title must be not blank");
        }
        if (StringUtils.isBlank(item.getUrl())) {
            throw new BadRequestException("item link must be not blank");
        }
    }

    private static void validate(QuickLinksData.FolderItem item) {
        if (StringUtils.isBlank(item.getTitle())) {
            throw new BadRequestException("item title must be not blank");
        }
        for (var subItem : item.getItemsList()) {
            validate(subItem);
        }
    }
}
