package ru.yandex.solomon.gateway.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.api.v3.CreateResourceRequest;
import ru.yandex.monitoring.api.v3.DeleteResourceRequest;
import ru.yandex.monitoring.api.v3.GetResourceRequest;
import ru.yandex.monitoring.api.v3.ListResourcesRequest;
import ru.yandex.monitoring.api.v3.ServiceProviderResourceId;
import ru.yandex.monitoring.api.v3.UpdateResourceRequest;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ServiceProviderResourceValidator {
    public static void validate(GetResourceRequest request) {
        switch (request.getContainerCase()) {
            case ABC_SLUG -> {
                if (request.getAbcSlug().isBlank()) {
                    throw new BadRequestException("abcSlug must be specified");
                }
            }
            default -> throw new BadRequestException(request.getContainerCase() + "not implemented");
        }
        validateId(request.getId());
    }

    private static void validateId(ServiceProviderResourceId id) {
        switch (id.getIdCase()) {
            case COMPLEX_ID -> {
                if (id.getComplexId().getServiceProviderId().isBlank()) {
                    throw new BadRequestException("serviceProviderId must be specified");
                }
                if (id.getComplexId().getResourceComplexIdMap().isEmpty()) {
                    throw new BadRequestException("resourceComplexId must be specified");
                }
                for (var entry : id.getComplexId().getResourceComplexIdMap().entrySet()) {
                    if (entry.getValue().isBlank() || entry.getKey().isBlank()) {
                        throw new BadRequestException("resourceComplexId must be specified without empty values");
                    }
                }
            }
            case RESOURCE_ID -> {
                if (id.getResourceId().isBlank()) {
                    throw new BadRequestException("resourceId must be specified");
                }
            }
            default -> throw new BadRequestException(id.getIdCase() + " not implemented");
        }
    }


    public static void validate(CreateResourceRequest request) {
        switch (request.getContainerCase()) {
            case ABC_SLUG -> {
                if (request.getAbcSlug().isBlank()) {
                    throw new BadRequestException("abcSlug must be specified");
                }
            }
            default -> throw new BadRequestException(request.getContainerCase() + "not implemented");
        }
        if (request.getName().isBlank()) {
            throw new BadRequestException("name must be specified");
        }
        if (request.getServiceProviderId().isBlank()) {
            throw new BadRequestException("serviceProviderId must be specified");
        }
        if (request.getType().isBlank()) {
            throw new BadRequestException("type must be specified");
        }
        if (request.getResourceComplexIdMap().isEmpty()) {
            throw new BadRequestException("resourceComplexId must be specified");
        }
        for (var entry : request.getResourceComplexIdMap().entrySet()) {
            if (entry.getValue().isBlank() || entry.getKey().isBlank()) {
                throw new BadRequestException("resourceComplexId must be specified without empty values");
            }
        }
    }

    public static void validate(UpdateResourceRequest request) {
        switch (request.getContainerCase()) {
            case ABC_SLUG -> {
                if (request.getAbcSlug().isBlank()) {
                    throw new BadRequestException("abcSlug must be specified");
                }
            }
            default -> throw new BadRequestException(request.getContainerCase() + "not implemented");
        }
        if (request.getName().isBlank()) {
            throw new BadRequestException("name must be specified");
        }
        if (request.getType().isBlank()) {
            throw new BadRequestException("type must be specified");
        }
        validateId(request.getId());
    }

    public static void validate(DeleteResourceRequest request) {
        switch (request.getContainerCase()) {
            case ABC_SLUG -> {
                if (request.getAbcSlug().isBlank()) {
                    throw new BadRequestException("abcSlug must be specified");
                }
            }
            default -> throw new BadRequestException(request.getContainerCase() + "not implemented");
        }
        validateId(request.getId());
    }

    public static void validate(ListResourcesRequest request) {
        switch (request.getContainerCase()) {
            case ABC_SLUG -> {
                if (request.getAbcSlug().isBlank()) {
                    throw new BadRequestException("abcSlug must be specified");
                }
            }
            default -> throw new BadRequestException(request.getContainerCase() + "not implemented");
        }
    }
}
