package ru.yandex.solomon.gateway.api.v3.utils;

import java.time.Instant;

import com.google.protobuf.Any;
import com.google.protobuf.StringValue;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.monitoring.api.v3.CreateStubRequest;
import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.gateway.stub.StubRequest;
import ru.yandex.solomon.idempotency.IdempotentOperation;

/**
 * @author Nuradil Zhambyl
 */
public class StubRequestIdempotency {
    public static final String CREATE_STUB_REQUEST_OPERATION = "createStubRequest";
    public static final String DELETE_STUB_REQUEST_OPERATION = "deleteStubRequest";

    public static IdempotentOperation operationCreate(CreateStubRequest proto) {
        if (StringUtils.isEmpty(proto.getId())) {
            return IdempotentOperation.NO_OPERATION;
        }
        return new IdempotentOperation(
                proto.getId(),
                proto.getServiceProviderId(),
                ContainerType.SERVICE_PROVIDER,
                CREATE_STUB_REQUEST_OPERATION,
                proto.getId(),
                Any.pack(StringValue.of(proto.getId())),
                Instant.now().toEpochMilli()
        );
    }

    public static IdempotentOperation operationDelete(StubRequest request) {
        if (StringUtils.isEmpty(request.id())) {
            return IdempotentOperation.NO_OPERATION;
        }
        return new IdempotentOperation(
                request.id(),
                request.id(),
                ContainerType.SERVICE_PROVIDER,
                DELETE_STUB_REQUEST_OPERATION,
                request.id(),
                Any.pack(StringValue.of(request.id())),
                Instant.now().toEpochMilli()
        );
    }
}
