package ru.yandex.solomon.gateway.api.v3alpha;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.v3.CreateDashboardRequest;
import ru.yandex.monitoring.v3.Dashboard;
import ru.yandex.monitoring.v3.DeleteDashboardRequest;
import ru.yandex.monitoring.v3.GetDashboardRequest;
import ru.yandex.monitoring.v3.ListDashboardRequest;
import ru.yandex.monitoring.v3.ListDashboardResponse;
import ru.yandex.monitoring.v3.UpdateDashboardRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface MonitoringDashboardService {
    CompletableFuture<Dashboard> getDashboard(GetDashboardRequest request, AuthSubject authSubject);

    CompletableFuture<Optional<Dashboard>> getDashboard(GetDashboardRequest request);

    CompletableFuture<ListDashboardResponse> listDashboards(ListDashboardRequest request, AuthSubject authSubject);

    CompletableFuture<Dashboard> createDashboard(CreateDashboardRequest request, AuthSubject account);

    CompletableFuture<Dashboard> updateDashboard(UpdateDashboardRequest request, AuthSubject account);

    CompletableFuture<Empty> deleteDashboard(DeleteDashboardRequest request, AuthSubject authSubject);
}
