package ru.yandex.solomon.gateway.api.v3alpha.cloud;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.solomon.auth.AuthContext;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.auth.internal.InternalAuthorizer;
import ru.yandex.solomon.cloud.resource.resolver.CloudByFolderResolver;
import ru.yandex.solomon.conf.db3.CloudFavoritesDao;
import ru.yandex.solomon.conf.db3.CloudServiceDashboardsDao;
import ru.yandex.solomon.conf.db3.ConfigV3DaoContext;
import ru.yandex.solomon.conf.db3.MonitoringDashboardsDao;
import ru.yandex.solomon.config.gateway.TGatewayCloudConfig;
import ru.yandex.solomon.core.db.dao.ConfigDaoContext;
import ru.yandex.solomon.core.db.dao.ServiceProvidersDao;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.PrivServiceDashboardService;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.PrivServiceDashboardServiceImpl;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.PrivServiceDashboardServiceStub;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.ServiceDashboardValidationContext;
import ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.ServiceDashboardValidationService;
import ru.yandex.solomon.gateway.cloud.search.NoopSearchEventSink;
import ru.yandex.solomon.gateway.cloud.search.SearchEventSink;

/**
 * @author Oleg Baryshnikov
 */
@Import({
        AuthContext.class,
        ConfigDaoContext.class,
        ConfigV3DaoContext.class,
        ServiceDashboardValidationContext.class,
})
@Configuration
@ParametersAreNonnullByDefault
public class CloudApiV3AlphaContext {

    @Bean
    public CloudMonitoringDashboardService cloudMonitoringDashboardService(
            Optional<TGatewayCloudConfig> config,
            Optional<CloudByFolderResolver> cloudByFolderResolver,
            Optional<SearchEventSink> searchEventSink,
            Authorizer authorizer,
            MonitoringDashboardsDao monitoringDashboardsDao,
            CloudFavoritesDao cloudFavoritesDao)
    {
        if (cloudByFolderResolver.isEmpty() || config.isEmpty()) {
            return new CloudMonitoringDashboardServiceStub();
        }
        return new CloudMonitoringDashboardServiceImpl(config.get().getEntityIdPrefix(), cloudByFolderResolver.get(),
                authorizer, monitoringDashboardsDao, cloudFavoritesDao, searchEventSink.orElseGet(NoopSearchEventSink::new));
    }

    @Bean
    public PrivServiceDashboardService privServiceDashboardService(
            @Qualifier("ClientId") String clientId,
            Optional<TGatewayCloudConfig> config,
            InternalAuthorizer internalAuthorizer,
            CloudServiceDashboardsDao cloudServiceDashboardsDao,
            MonitoringDashboardsDao monitoringDashboardsDao,
            ServiceProvidersDao serviceProvidersDao,
            ServiceDashboardValidationService serviceDashboardValidationService)
    {
        if (config.isEmpty()) {
            return new PrivServiceDashboardServiceStub();
        }
        boolean production = "solomon-gateway-cloud-prod".equals(clientId);
        String entityIdPrefix = config.get().getEntityIdPrefix();
        return new PrivServiceDashboardServiceImpl(
                production,
                entityIdPrefix,
                internalAuthorizer,
                cloudServiceDashboardsDao,
                monitoringDashboardsDao,
                serviceProvidersDao,
                serviceDashboardValidationService);
    }

}
