package ru.yandex.solomon.gateway.api.v3alpha.cloud;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.v3.cloud.CreateDashboardRequest;
import ru.yandex.monitoring.v3.cloud.Dashboard;
import ru.yandex.monitoring.v3.cloud.DeleteDashboardRequest;
import ru.yandex.monitoring.v3.cloud.GetDashboardRequest;
import ru.yandex.monitoring.v3.cloud.ListDashboardRequest;
import ru.yandex.monitoring.v3.cloud.ListDashboardResponse;
import ru.yandex.monitoring.v3.cloud.UpdateDashboardRequest;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface CloudMonitoringDashboardService {
    CompletableFuture<Dashboard> getDashboard(GetDashboardRequest request, AuthSubject authSubject);

    CompletableFuture<ListDashboardResponse> listDashboards(ListDashboardRequest request, AuthSubject authSubject);

    CompletableFuture<Dashboard> createDashboard(CreateDashboardRequest request, AuthSubject authSubject);

    CompletableFuture<Dashboard> updateDashboard(UpdateDashboardRequest request, AuthSubject authSubject);

    CompletableFuture<Empty> deleteDashboard(DeleteDashboardRequest request, AuthSubject authSubject);
}
