package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.monitoring.v3.cloud.ServiceDashboard;
import ru.yandex.monitoring.v3.cloud.priv.CreateServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.DeleteServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.GetServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.ListServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.ListServiceDashboardResponse;
import ru.yandex.monitoring.v3.cloud.priv.ServiceDashboardServiceGrpc;
import ru.yandex.monitoring.v3.cloud.priv.SyncServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.UpdateServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.ValidateServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.ValidationServiceDashboardResponse;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.grpc.AuthenticationInterceptor;
import ru.yandex.solomon.exception.handlers.GrpcApiExceptionResolver;

import static ru.yandex.grpc.utils.StreamObservers.asyncComplete;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcPrivServiceDashboardService extends ServiceDashboardServiceGrpc.ServiceDashboardServiceImplBase implements GrpcService {
    private final PrivServiceDashboardService serviceDashboardService;

    @Autowired
    public GrpcPrivServiceDashboardService(PrivServiceDashboardService serviceDashboardService) {
        this.serviceDashboardService = serviceDashboardService;
    }

    @Override
    public void get(GetServiceDashboardRequest request, StreamObserver<ServiceDashboard> responseObserver) {
        asyncComplete(CompletableFutures.safeCall(() -> getImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<ServiceDashboard> getImpl(GetServiceDashboardRequest request) {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.get(request, authSubject);
    }

    @Override
    public void list(ListServiceDashboardRequest request, StreamObserver<ListServiceDashboardResponse> responseObserver) {
        asyncComplete(CompletableFutures.safeCall(() -> listImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<ListServiceDashboardResponse> listImpl(ListServiceDashboardRequest request) {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.list(request, authSubject);
    }

    @Override
    public void create(CreateServiceDashboardRequest request, StreamObserver<ServiceDashboard> responseObserver) {
        asyncComplete(CompletableFutures.safeCall(() -> createImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<ServiceDashboard> createImpl(CreateServiceDashboardRequest request) {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.create(request, authSubject);
    }

    @Override
    public void update(UpdateServiceDashboardRequest request, StreamObserver<ServiceDashboard> responseObserver) {
        asyncComplete(CompletableFutures.safeCall(() -> updateImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<ServiceDashboard> updateImpl(UpdateServiceDashboardRequest request) {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.update(request, authSubject);
    }

    @Override
    public void validate(
            ValidateServiceDashboardRequest request,
            StreamObserver<ValidationServiceDashboardResponse> responseObserver)
    {
        asyncComplete(CompletableFutures.safeCall(() -> validateImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<ValidationServiceDashboardResponse> validateImpl(
            ValidateServiceDashboardRequest request)
    {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.validate(request, authSubject);
    }

    @Override
    public void delete(DeleteServiceDashboardRequest request, StreamObserver<Empty> responseObserver) {
        asyncComplete(CompletableFutures.safeCall(() -> deleteImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<Empty> deleteImpl(DeleteServiceDashboardRequest request) {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.delete(request, authSubject);
    }

    @Override
    public void sync(SyncServiceDashboardRequest request, StreamObserver<ServiceDashboard> responseObserver) {
        asyncComplete(CompletableFutures.safeCall(() -> syncImpl(request))
                        .exceptionally(throwable -> {
                            throw GrpcApiExceptionResolver.doResolveException(throwable);
                        })
                , responseObserver);
    }

    private CompletableFuture<ServiceDashboard> syncImpl(SyncServiceDashboardRequest request) {
        AuthSubject authSubject = AuthenticationInterceptor.getAuthSubject(Context.current());
        return serviceDashboardService.sync(request, authSubject);
    }
}
