package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.monitoring.v3.cloud.priv.CreateServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.DeleteServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.GetServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.ListServiceDashboardRequest;
import ru.yandex.monitoring.v3.cloud.priv.UpdateServiceDashboardRequest;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ServiceDashboardRequestValidator {

    public static void validate(CreateServiceDashboardRequest request) {
        if (StringUtils.isBlank(request.getService())) {
            throw new BadRequestException("service cannot be blank");
        }
        if (StringUtils.isBlank(request.getName())) {
            throw new BadRequestException("name cannot be blank");
        }
    }

    public static void validate(ListServiceDashboardRequest request) {
        if (StringUtils.isBlank(request.getService())) {
            throw new BadRequestException("service cannot be blank");
        }
    }

    public static void validate(GetServiceDashboardRequest request) {
        validateId(request.getServiceDashboardId());
    }

    public static void validate(UpdateServiceDashboardRequest request) {
        validateId(request.getServiceDashboardId());
    }

    public static void validate(DeleteServiceDashboardRequest request) {
        validateId(request.getServiceDashboardId());
    }

    public static void validateId(String id) {
        if (StringUtils.isBlank(id)) {
            throw new BadRequestException("service dashboard ID cannot be blank");
        }
    }
}
