package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.v3.cloud.ChartWidget;
import ru.yandex.monitoring.v3.cloud.Dashboard;
import ru.yandex.monitoring.v3.cloud.Parametrization;
import ru.yandex.monitoring.v3.cloud.ServiceDashboard;
import ru.yandex.monitoring.v3.cloud.Widget;
import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ServiceDashboardSync {
    private static final Pattern pattern = Pattern.compile("folderId=\"[^\"]+\"");

    public static ServiceDashboard merge(Dashboard srcDashboard, ServiceDashboard targetServiceDashboard, String sourceDashboardLink) {
        List<Widget> newWidgets = srcDashboard.getWidgetsList().stream()
                .map(ServiceDashboardSync::convertWidget)
                .collect(Collectors.toList());

        Parametrization newParametrization = convertParametrization(srcDashboard.getParametrization());

        return targetServiceDashboard.toBuilder()
                .clearWidgets()
                .setSourceDashboardLink(sourceDashboardLink)
                .setName(srcDashboard.getName())
                .addAllWidgets(newWidgets)
                .setParametrization(newParametrization)
                .build();
    }

    private static Parametrization convertParametrization(Parametrization parametrization) {
        var newSelectors = Selectors.parse(parametrization.getSelectors())
                .toBuilder()
                .remove("folderId")
                .build()
                .toString();

        var newParameters = parametrization.getParametersList().stream()
                .map(p -> {
                    if (!p.hasLabelValues()) {
                        return p;
                    }
                    return p.toBuilder()
                            .setLabelValues(p.getLabelValues().toBuilder()
                                    .setFolderId("$FOLDER_ID")
                                    .clearSelectors())
                            .build();
                })
                .collect(Collectors.toList());
        return parametrization.toBuilder()
                .clearParameters()
                .addAllParameters(newParameters)
                .setSelectors(newSelectors)
                .build();
    }

    private static Widget convertWidget(Widget widget) {
        if (!widget.hasChart()) {
            return widget;
        }

        ChartWidget chart = widget.getChart();
        ChartWidget.Queries queries = chart.getQueries();

        List<ChartWidget.Queries.Target> newTargets = queries.getTargetsList()
                .stream()
                .map(target -> {
                    String newQuery = convertQuery(target.getQuery());
                    return target.toBuilder()
                            .setQuery(newQuery)
                            .build();
                })
                .collect(Collectors.toList());

        ChartWidget.Queries newQueries = queries.toBuilder()
                .clearTargets()
                .addAllTargets(newTargets)
                .build();

        ChartWidget newChart = chart.toBuilder()
                .setQueries(newQueries)
                .build();

        return widget.toBuilder()
                .setChart(newChart)
                .build();
    }

    private static String convertQuery(String query) {
        return pattern.matcher(query).replaceAll("folderId=\"{{folderId}}\"");
    }
}
